import { View, Text, TextInput, Pressable } from "react-native";
import React from "react";
import { filtersStyles } from "./filtersStyle";
import { addNewAddressStyle } from "../../Profile/Address/AddNewAddress/AddNewAddressStyle";
import useLangTranslation from "../../../hooks/useLangTranslation";
import gapStyle from "../../Utilities/CommonStyles/gap.style";

const FilterInput = ({
    minPrice,
    setMin_Price,
    maxPrice,
    setMax_Price,
    handleUpdatePrice,
}) => {
    const { trans } = useLangTranslation();
    return (
        <>
            <Text
                style={[filtersStyles.selectText,filtersStyles.priceRange]}
            >
                {trans("Price Range")}
            </Text>
            <View style={filtersStyles.inputCont}>
                <View
                    style={[filtersStyles.inputGroup, gapStyle.mr25]}
                >
                    <Text style={filtersStyles.inputText}>{trans("Min.")}</Text>
                    <TextInput
                        style={[filtersStyles.input, filtersStyles.selectText]}
                        placeholder={`0`}
                        placeholderTextColor={"#2C2C2C"}
                        keyboardType='numeric'
                        maxLength={10}
                        value={minPrice.toString()}
                        onChangeText={(text) => setMin_Price(text)}
                    />
                </View>
                <View
                    style={[filtersStyles.inputGroup, gapStyle.mr25]}
                >
                    <Text style={filtersStyles.inputText}>{trans("Max.")}</Text>
                    <TextInput
                        style={[filtersStyles.input, filtersStyles.selectText]}
                        placeholder={`0`}
                        placeholderTextColor={"#2C2C2C"}
                        keyboardType='numeric'
                        value={maxPrice.toString()}
                        onChangeText={(text) => setMax_Price(text)}
                    />
                </View>
            </View>
            <Pressable
                style={addNewAddressStyle.saveAddressCont}
                onPress={handleUpdatePrice}
            >
                <Text style={addNewAddressStyle.saveAddressBtn}>
                    {trans("Update Price")}
                </Text>
            </Pressable>
        </>
    );
};

export default FilterInput;
